<?php
  /**
   * Filemanager Class
   *
   * @package CMS Pro
   * @author wojoscripts.com
   * @copyright 2010
   * @version $Id: class_fm.php, v2.00 2011-04-20 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
  
  class Filemanager
  {
      private $base_dir;
      private $file_list = array();
      private $file_count = 0;
	  private $cfiles = 0;
	  
	  protected $ext = array();
	  private $fsize = 0;
	  private $fileext = array(".gif", ".jpg", ".jpeg", ".png", ".txt", ".nfo", ".doc", ".docx", ".xls", ".xlsx", ".htm", ".zip", ".rar", ".css", ".pdf", ".swf", ".mp4", ".mp3");
      
      
      
      /**
       * Filemanager::__construct()
       * 
       * @return
       */
      function __construct()
      {
          global $core;
          $this->base_dir = str_replace("\\", "/", $core->file_dir);
          $this->getDir();

          if (!is_dir($this->base_dir))
              die($core->msgError('<span>Error!</span>' . $this->base_dir . 'is not a directory !!!', false));
			  
          if (!($dir = opendir($this->base_dir)))
              die($core->msgError('<span>Error!</span>' . $this->base_dir . 'Access denied . <br>You do not have enough rights to view the dir', false));

      }
	  
		
      /**
       * Filemanager::getDir()
       * 
       * @return
       */
      private function getDir()
      {
          if ($handle = opendir($this->base_dir)) {
              while (false !== ($name = readdir($handle))) {
                  if ($name == ".." || $name == "." || $name == "index.php" || $name == "index.html" || $name == "Thumbs.db" || $name == ".htaccess")
                      continue;
					  
                  if (is_file($this->base_dir . $name))
                      $this->file_list[$this->file_count++] = $name;
              }
              closedir($handle);
          }
      }

	  
	  /**
	   * Filemanager::renderThumbs()
	   * 
	   * @return
	   */
	  public function renderThumbs()
	  {
		  global $core;
		  
		  sort($this->file_list);
		  $data = '';
		  if(!$this->file_list) {
			  $core->msgInfo('<span>Info!</span>You don\'t have any files yet. Start uploading...',false);
		  } else {
		  for ($i = 0; $i < $this->file_count; $i++) {
			  $this->ext = explode(".", $this->file_list[$i], strlen($this->file_list[$i]));
			  $extn = $this->ext[count($this->ext) - 1];
			  $data .= '<div class="thumbview"><div class="inner"><span class="control"><a href="javascript:void(0);" rel="' . $this->file_list[$i] . '" class="del-single">
			  <img src="images/delete2.png" alt="" title="Delete" class="tooltip img-wrap2"/></a><a href="javascript:void(0);" rel="' . $this->file_list[$i] . '" class="edit-single">
			  <img src="images/edit.png" alt="" title="Edit" class="tooltip img-wrap2"/></a></span>';
			  $data .= '<img src="filemanager/images/mime/large/' . $this->getFileType($extn) . '" alt="" title="' . $this->file_list[$i] . '" class="tooltip"/>';
			  $data .= '<div class="title">'.sanitize($this->file_list[$i],30).'</div></div>';	
			  $data .= '</div>';
		  }		 
		$this->cfiles++;
		$data .= '';
		print $data;
		  }
	  }
	  
      /**
       * Filemanager::delete()
       * 
	   * @param bool $name
	   * @return
       */
	  public function delete($name)
	  {
		  global $db, $core;
		  
		  if (file_exists($this->base_dir . $name)) {
			  if (unlink($this->base_dir . $name)) {
				  $core->msgOK('<span>Success!</span>File <strong> ' . $name . ' </strong> was deleted successfully.');
				  $db->delete("files", "name='" . $name . "'");
			  } else
				  $core->msgError('<span>Error!</span>There was an Error Deleting File <strong> ' . $name . ' </strong>');
		  } else
			  $core->msgError('<span>Error!</span>Invalid File Selected',false);
	  }

      /**
       * Filemanager::arename()
       * 
	   * @param bool $name
	   * @param bool $name
	   * @return
       */
	  public function arename($name, $alias)
	  {
		  global $db, $core;
		  $name = sanitize($name);
		  $name = $db->escape($name);
		  
		  $alias = sanitize($alias);
		  $alias = $db->escape($alias);
		  
		  if ($row = $db->first("SELECT name FROM files WHERE name = '".$name."'")) {
			  
			  $data['alias'] = $alias;
			  $db->update("files", $data, "name = '".$row['name']."'");
			  
			  $core->msgOK('<span>Success!</span>File Alias &rsaquo; <strong> ' . $name . ' </strong> was renamed successfully.');
		  } else {
			  $core->msgError('<span>Error!</span>There was an Error Renaming File Alias &rsaquo; <strong> ' . $name . ' </strong>. No record exists.',false);
		  }

	  }
	  
	  /**
	   * Filemanager::uploadFile()
	   * 
	   * @param mixed $path
	   * @param mixed $name
	   * @return
	   */
	  public function uploadFile($path)
	  {
		  global $db, $core;
		  
		  if (!is_dir($this->base_dir))
			  die($core->msgError('Error: The upload directory doesn\'t exist!'));
		  
		  if (!is_writeable($this->base_dir))
			  die($core->msgError('Error: The upload directory is NOT writable!'));
		  
		  $newfile = $_FILES['newfile'];
		  $filename = $newfile['name'];
		  
		  $filename = str_replace(' ', '_', $filename);
		  $filetmp = $newfile['tmp_name'];
		  $filesize = $newfile['size'];
		  
		  $ext = strrchr($filename, '.');
		  if (!in_array(strtolower($ext), $this->fileext)) {
			  die($core->msgError('File <strong> ' . $filename . ' </strong> Wrong file extension'));
		  }

		  if (!is_uploaded_file($filetmp)) {
			  $core->msgs['file'] = 'File <strong> ' . $filename . ' </strong> Not selected';
		  }
		  
		  if (file_exists($this->base_dir . $filename)) {
			  $core->msgs['file'] = 'File <strong> ' . $filename . ' </strong> already exists';
		  }
		  
		  if (empty($core->msgs)) {
			  if (move_uploaded_file($filetmp, $this->base_dir . $filename)) {
				  
				  $data = array(
					  'name' => sanitize($filename), 
					  'alias' => sanitize($_POST['alias']), 
					  'filesize' => $filesize,
					  'created' => "NOW()",
					  'active' => 1
				  );
				  $db->insert("files", $data);
				  $core->msgOk('File <strong> ' . $filename . ' </strong> uploaded successfully');
			  } else
				  $core->msgs['file'] = 'File <strong> ' . $filename . ' </strong> Failed to upload';

		  } else
			  print $core->msgStatus();
	  }

	  /**
	   * Filemanager::getFileType()
	   * 
	   * @param mixed $extn
	   * @return
	   */
	  private function getFileType($extn) {
		  
		switch ($extn) {
			case "css":
				return "css.png";
				break;
				
			case "csv":
				return "csv.png";
				break;
				
			case "fla":
			case "swf":
				return "fla.png";
				break;
				
			case "mp3":
			case "wav":
				return "mp3.png";
				break;

			case "jpg":
			case "JPG":
			case "jpeg":
				return "jpg.png";
				break;
				
			case "png":
				return "png.png";
				break;
				
			case "gif":
				return "gif.png";
				break;
				
			case "bmp":
			case "dib":
				return "bmp.png";
				break;
				
			case "txt":
			case "log":
				return "txt.png";
				break;
				
			case "sql":
				return "sql.png";
				break;
								
			case "js":
				echo "js.png";
				break;
				
			case "pdf":
				return "pdf.png";
				break;
				
			case "zip":
			case "rar":
			case "tgz":
			case "gz":
				return "zip.png";
				break;
				
			case "doc":
			case "docx":
			case "rtf":
				return "doc.png";
				break;
				
			case "asp":
			case "jsp":
				echo "asp.png";
				break;
				
			case "php":
				return "php.png";
				break;
				
			case "htm":
			case "html":
				return "htm.png";
				break;
				
			case "ppt":
				return "ppt.png";
				break;
				
			case "exe":
			case "bat":
			case "com":
				return "exe.png";
				break;
				
			case "wmv":
			case "mpg":
			case "mpeg":
			case "wma":
			case "asf":
				return "wmv.png";
				break;
				
			case "midi":
			case "mid":
				return "midi.png";
				break;
				
			case "mov":
				return "mov.png";
				break;
				
			case "psd":
				return "psd.png";
				break;
				
			case "ram":
			case "rm":
				return "rm.png";
				break;
				
			case "xml":
				return "xml.png";
				break;

			case "xls":
			case "xlsx":
				return "xls.png";
				break;
				
			default:
				return "default.png";
				break;
		}	

	  }
  }
?>